clear;
load('testR.mat');  %it is in Data folder

n = 100;
for i=1:7
    mydata(n*(i-1)+1:n*i,:,:) = imageData(100*(i-1)+1:100*(i-1)+n,:,:);
end
mydata = im2double(mydata);

N = 7*n;
d = 2;
db=cell(1,1);
db{1}.stride = zeros(1,N);

for i=1:N
    v  = find(mydata(i,:,:));
    db{1}.stride(i) = length(v);
end

stride_cumsum = [0,cumsum(db{1}.stride)] ;
db{1}.w = zeros(1,stride_cumsum(end));
db{1}.supp = zeros(d,stride_cumsum(end));

for i=1:N
    A = reshape(mydata(i,:,:),[28,28]);
    [row,col,v]  = find(A);
    db{1}.supp(:,stride_cumsum(i)+1:stride_cumsum(i+1)) = [row';col'];
    db{1}.w(stride_cumsum(i)+1:stride_cumsum(i+1)) = v./sum(v);
end

c0 = cell(1,1);
c0{1}.w = ones(1,784)./784;

row = kron(ones(1,28),1:28);
col = kron(1:28,ones(1,28));
c0{1}.supp = [row;col];

options.method='WBC';
options.ipmouttolog = 1;
options.ipmtol_primal_dual_gap = 1e-4; 
options.largem = 1;
[c, OT]=WBC(db, c0, options);
options.method='WB';
[cw, OTw] = WBC(db, c0, options);

save('resultR.mat','c','cw','OT','OTw');




